#ifndef __EPL_ERROR_H
#define __EPL_ERROR_H

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL PDO Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_PDO_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_PDO_COMMAND_INVALID    ((TLR_RESULT)0xC0150001L)

//
// MessageId: TLR_E_EPL_PDO_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup parameter.
//
#define TLR_E_EPL_PDO_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0150002L)

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL SDO Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_SDO_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_SDO_COMMAND_INVALID    ((TLR_RESULT)0xC0160001L)

//
// MessageId: TLR_E_EPL_SDO_PROTOCOL_TIMEOUT
//
// MessageText:
//
//  SDO Protocol timeout.
//
#define TLR_E_EPL_SDO_PROTOCOL_TIMEOUT   ((TLR_RESULT)0xC0160002L)

//
// MessageId: TLR_E_EPL_SDO_SCS_SPECIFIER_INVALID
//
// MessageText:
//
//  Client/Server command specifier not valid or unknown.
//
#define TLR_E_EPL_SDO_SCS_SPECIFIER_INVALID ((TLR_RESULT)0xC0160003L)

//
// MessageId: TLR_E_EPL_SDO_OUT_OF_MEMORY
//
// MessageText:
//
//  Out of Memory.
//
#define TLR_E_EPL_SDO_OUT_OF_MEMORY      ((TLR_RESULT)0xC0160004L)

//
// MessageId: TLR_E_EPL_SDO_UNSUPPORTED_ACCESS_TO_OBJECT
//
// MessageText:
//
//  Unsupported access to an object.
//
#define TLR_E_EPL_SDO_UNSUPPORTED_ACCESS_TO_OBJECT ((TLR_RESULT)0xC0160005L)

//
// MessageId: TLR_E_EPL_SDO_ATTEMPT_TO_READ_A_WRITE_ONLY_OBJECT
//
// MessageText:
//
//  Attempt to read a write only object.
//
#define TLR_E_EPL_SDO_ATTEMPT_TO_READ_A_WRITE_ONLY_OBJECT ((TLR_RESULT)0xC0160006L)

//
// MessageId: TLR_E_EPL_SDO_ATTEMPT_TO_WRITE_A_READ_ONLY_OBJECT
//
// MessageText:
//
//  Attempt to write a read only object.
//
#define TLR_E_EPL_SDO_ATTEMPT_TO_WRITE_A_READ_ONLY_OBJECT ((TLR_RESULT)0xC0160007L)

//
// MessageId: TLR_E_EPL_SDO_OBJECT_DOES_NOT_EXIST
//
// MessageText:
//
//  The object does not exist in the object dictionary.
//
#define TLR_E_EPL_SDO_OBJECT_DOES_NOT_EXIST ((TLR_RESULT)0xC0160008L)

//
// MessageId: TLR_E_EPL_SDO_OBJECT_CAN_NOT_BE_MAPPED_INTO_THE_PDO
//
// MessageText:
//
//  The object can not be mapped into the PDO.
//
#define TLR_E_EPL_SDO_OBJECT_CAN_NOT_BE_MAPPED_INTO_THE_PDO ((TLR_RESULT)0xC0160009L)

//
// MessageId: TLR_E_EPL_SDO_OBJECTS_WOULD_EXCEED_PDO_LENGTH
//
// MessageText:
//
//  The number and length of the objects to be mapped would exceed the PDO length.
//
#define TLR_E_EPL_SDO_OBJECTS_WOULD_EXCEED_PDO_LENGTH ((TLR_RESULT)0xC016000AL)

//
// MessageId: TLR_E_EPL_SDO_GENERAL_PARAMETER_INCOMPATIBILITY_REASON
//
// MessageText:
//
//  General parameter incompatibility reason.
//
#define TLR_E_EPL_SDO_GENERAL_PARAMETER_INCOMPATIBILITY_REASON ((TLR_RESULT)0xC016000BL)

//
// MessageId: TLR_E_EPL_SDO_GENERAL_INTERNAL_INCOMPATIBILITY_IN_DEVICE
//
// MessageText:
//
//  General internal incompatibility in the device.
//
#define TLR_E_EPL_SDO_GENERAL_INTERNAL_INCOMPATIBILITY_IN_DEVICE ((TLR_RESULT)0xC016000CL)

//
// MessageId: TLR_E_EPL_SDO_ACCESS_FAILED_DUE_TO_A_HARDWARE_ERROR
//
// MessageText:
//
//  Access failed due to a hardware error.
//
#define TLR_E_EPL_SDO_ACCESS_FAILED_DUE_TO_A_HARDWARE_ERROR ((TLR_RESULT)0xC016000DL)

//
// MessageId: TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_DOES_NOT_MATCH
//
// MessageText:
//
//  Data type does not match, length of service parameter does not match.
//
#define TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_DOES_NOT_MATCH ((TLR_RESULT)0xC016000EL)

//
// MessageId: TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_HIGH
//
// MessageText:
//
//  Data type does not match, length of service parameter too high.
//
#define TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_HIGH ((TLR_RESULT)0xC016000FL)

//
// MessageId: TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_LOW
//
// MessageText:
//
//  Data type does not match, length of service parameter too low.
//
#define TLR_E_EPL_SDO_DATA_TYPE_DOES_NOT_MATCH_LEN_OF_SRV_PARAM_TOO_LOW ((TLR_RESULT)0xC0160010L)

//
// MessageId: TLR_E_EPL_SDO_SUBINDEX_DOES_NOT_EXIST
//
// MessageText:
//
//  Subindex does not exist.
//
#define TLR_E_EPL_SDO_SUBINDEX_DOES_NOT_EXIST ((TLR_RESULT)0xC0160011L)

//
// MessageId: TLR_E_EPL_SDO_VALUE_RANGE_OF_PARAMETER_EXCEEDED
//
// MessageText:
//
//  Value range of parameter exceeded.
//
#define TLR_E_EPL_SDO_VALUE_RANGE_OF_PARAMETER_EXCEEDED ((TLR_RESULT)0xC0160012L)

//
// MessageId: TLR_E_EPL_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_HIGH
//
// MessageText:
//
//  Value of parameter written too high.
//
#define TLR_E_EPL_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_HIGH ((TLR_RESULT)0xC0160013L)

//
// MessageId: TLR_E_EPL_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_LOW
//
// MessageText:
//
//  Value of parameter written too low.
//
#define TLR_E_EPL_SDO_VALUE_OF_PARAMETER_WRITTEN_TOO_LOW ((TLR_RESULT)0xC0160014L)

//
// MessageId: TLR_E_EPL_SDO_MAXIMUM_VALUE_IS_LESS_THAN_MINIMUM_VALUE
//
// MessageText:
//
//  Maximum value is less than minimum value.
//
#define TLR_E_EPL_SDO_MAXIMUM_VALUE_IS_LESS_THAN_MINIMUM_VALUE ((TLR_RESULT)0xC0160015L)

//
// MessageId: TLR_E_EPL_SDO_GENERAL_ERROR
//
// MessageText:
//
//  General error.
//
#define TLR_E_EPL_SDO_GENERAL_ERROR      ((TLR_RESULT)0xC0160016L)

//
// MessageId: TLR_E_EPL_SDO_DATA_CANNOT_BE_TRANSFERRED_OR_STORED_TO_THE_APP
//
// MessageText:
//
//  Data cannot be transferred or stored to the application.
//
#define TLR_E_EPL_SDO_DATA_CANNOT_BE_TRANSFERRED_OR_STORED_TO_THE_APP ((TLR_RESULT)0xC0160017L)

//
// MessageId: TLR_E_EPL_SDO_DATA_NO_TRANSFER_DUE_TO_LOCAL_CONTROL
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of local control.
//
#define TLR_E_EPL_SDO_DATA_NO_TRANSFER_DUE_TO_LOCAL_CONTROL ((TLR_RESULT)0xC0160018L)

//
// MessageId: TLR_E_EPL_SDO_DATA_NO_TRANSFER_DUE_TO_PRESENT_DEVICE_STATE
//
// MessageText:
//
//  Data cannot be transferred or stored to the application because of present device state.
//
#define TLR_E_EPL_SDO_DATA_NO_TRANSFER_DUE_TO_PRESENT_DEVICE_STATE ((TLR_RESULT)0xC0160019L)

//
// MessageId: TLR_E_EPL_SDO_NO_OBJECT_DICTIONARY_PRESENT
//
// MessageText:
//
//  Object dictionary dynamic generation fails or no object dictionary present.
//
#define TLR_E_EPL_SDO_NO_OBJECT_DICTIONARY_PRESENT ((TLR_RESULT)0xC016001AL)

//
// MessageId: TLR_E_EPL_SDO_UNKNOWN_ABORT_CODE
//
// MessageText:
//
//  Unknown SDO abort code.
//
#define TLR_E_EPL_SDO_UNKNOWN_ABORT_CODE ((TLR_RESULT)0xC016001BL)

//
// MessageId: TLR_E_EPL_CONN_BUFFER_FULL
//
// MessageText:
//
//  Connection buffer full.
//
#define TLR_E_EPL_CONN_BUFFER_FULL       ((TLR_RESULT)0xC016001CL)

//
// MessageId: TLR_E_EPL_SDO_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup parameter.
//
#define TLR_E_EPL_SDO_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC016001DL)

//
// MessageId: TLR_E_EPLCN_SDO_OD_DPM_MODE_OBJECTS_CAN_ONLY_BE_READONLY
//
// MessageText:
//
//  DPM Mode Objects can only be set readonly.
//
#define TLR_E_EPLCN_SDO_OD_DPM_MODE_OBJECTS_CAN_ONLY_BE_READONLY ((TLR_RESULT)0xC016001EL)

//
// MessageId: TLR_E_EPLCN_SDO_OD_DPM_MODE_OBJECTS_DIRECTION_PARAMETER_INVALID
//
// MessageText:
//
//  Invalid direction parameter for DPM Mode Objects.
//
#define TLR_E_EPLCN_SDO_OD_DPM_MODE_OBJECTS_DIRECTION_PARAMETER_INVALID ((TLR_RESULT)0xC016001FL)

//
// MessageId: TLR_E_EPLCN_SDO_OD_DPM_MODE_SUBOBJECT_OFFSET_OUT_OF_RANGE
//
// MessageText:
//
//  Invalid offset parameter for DPM Mode Objects.
//
#define TLR_E_EPLCN_SDO_OD_DPM_MODE_SUBOBJECT_OFFSET_OUT_OF_RANGE ((TLR_RESULT)0xC0160020L)

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL ALI Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_ALI_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_ALI_COMMAND_INVALID    ((TLR_RESULT)0xC0180001L)

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL NMT Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_NMT_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_NMT_COMMAND_INVALID    ((TLR_RESULT)0xC0170001L)

//
// MessageId: TLR_E_EPL_NMT_OUTPUT_DATA_INVALID
//
// MessageText:
//
//  Output data invalid.
//
#define TLR_E_EPL_NMT_OUTPUT_DATA_INVALID ((TLR_RESULT)0xC0170002L)

//
// MessageId: TLR_E_EPL_NMT_INPUT_DATA_OVERSIZED
//
// MessageText:
//
//  Input data oversized.
//
#define TLR_E_EPL_NMT_INPUT_DATA_OVERSIZED ((TLR_RESULT)0xC0170003L)

//
// MessageId: TLR_E_EPL_NMT_NODE_INPUT_DATA_INVALID
//
// MessageText:
//
//  Node-specific Input data invalid.
//
#define TLR_E_EPL_NMT_NODE_INPUT_DATA_INVALID ((TLR_RESULT)0xC0170004L)

//
// MessageId: TLR_E_EPL_NMT_PDO_DOES_NOT_EXIST
//
// MessageText:
//
//  Node-specific PDO does not exist.
//
#define TLR_E_EPL_NMT_PDO_DOES_NOT_EXIST ((TLR_RESULT)0xC0170005L)

//
// MessageId: TLR_E_EPL_NMT_PDO_EXISTS
//
// MessageText:
//
//  Node-specific PDO exists.
//
#define TLR_E_EPL_NMT_PDO_EXISTS         ((TLR_RESULT)0xC0170006L)

//
// MessageId: TLR_E_EPL_NMT_PDO_EXCEEDS_POLL_IN_SIZE
//
// MessageText:
//
//  PDO will exceed Poll In size.
//
#define TLR_E_EPL_NMT_PDO_EXCEEDS_POLL_IN_SIZE ((TLR_RESULT)0xC0170007L)

//
// MessageId: TLR_E_EPL_NMT_PDO_EXCEEDS_POLL_OUT_SIZE
//
// MessageText:
//
//  PDO will exceed Poll Out size.
//
#define TLR_E_EPL_NMT_PDO_EXCEEDS_POLL_OUT_SIZE ((TLR_RESULT)0xC0170008L)

//
// MessageId: TLR_E_EPL_NMT_INVALID_STARTUP_PARAMETER
//
// MessageText:
//
//  Invalid Startup parameter.
//
#define TLR_E_EPL_NMT_INVALID_STARTUP_PARAMETER ((TLR_RESULT)0xC0170009L)

//
// MessageId: TLR_E_EPL_NMT_INVALID_STATE_CHANGE
//
// MessageText:
//
//  Invalid state change requested.
//
#define TLR_E_EPL_NMT_INVALID_STATE_CHANGE ((TLR_RESULT)0xC017000AL)

//
// MessageId: TLR_E_EPL_NMT_FAILED_TO_LOCK_MUTEX
//
// MessageText:
//
//  Failed to lock mutex.
//
#define TLR_E_EPL_NMT_FAILED_TO_LOCK_MUTEX ((TLR_RESULT)0xC017000BL)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_MUTEX
//
// MessageText:
//
//  Could not create SDO mutex.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_MUTEX ((TLR_RESULT)0xC017000CL)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_MUTEX
//
// MessageText:
//
//  Could not create NMT mutex.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_MUTEX ((TLR_RESULT)0xC017000DL)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_ERRH_MUTEX
//
// MessageText:
//
//  Could not create Error Handling mutex.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_ERRH_MUTEX ((TLR_RESULT)0xC017000EL)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_TASK
//
// MessageText:
//
//  Could not create SDO task.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_TASK ((TLR_RESULT)0xC017000FL)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_TASK
//
// MessageText:
//
//  Could not create NMT task.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_TASK ((TLR_RESULT)0xC0170010L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_SIGNAL
//
// MessageText:
//
//  Could not create SDO signal.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_SDO_SIGNAL ((TLR_RESULT)0xC0170011L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_SIGNAL
//
// MessageText:
//
//  Could not create NMT signal.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_NMT_SIGNAL ((TLR_RESULT)0xC0170012L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_BASIC_ETH_TIMER
//
// MessageText:
//
//  Could not create Basic Ethernet timer.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_BASIC_ETH_TIMER ((TLR_RESULT)0xC0170013L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_SOC_TIMER
//
// MessageText:
//
//  Could not create SoC timer.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_SOC_TIMER ((TLR_RESULT)0xC0170014L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_SEQU_LAYER_TIMER
//
// MessageText:
//
//  Could not create Sequence Layer timer.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_SEQU_LAYER_TIMER ((TLR_RESULT)0xC0170015L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_CREATE_OBJECT_DICTIONARY
//
// MessageText:
//
//  Could not create object dictionary.
//
#define TLR_E_EPL_NMT_COULD_NOT_CREATE_OBJECT_DICTIONARY ((TLR_RESULT)0xC0170016L)

//
// MessageId: TLR_E_EPL_NMT_EMERGENCY_QUEUE_OVERFLOW
//
// MessageText:
//
//  Emergency Queue overflow.
//
#define TLR_E_EPL_NMT_EMERGENCY_QUEUE_OVERFLOW ((TLR_RESULT)0xC0170017L)

//
// MessageId: TLR_E_EPL_NMT_INVALID_STATUS_ENTRY_INDEX
//
// MessageText:
//
//  Invalid status entry index.
//
#define TLR_E_EPL_NMT_INVALID_STATUS_ENTRY_INDEX ((TLR_RESULT)0xC0170018L)

//
// MessageId: TLR_E_EPL_NMT_COULD_NOT_LOCK_MUTEX
//
// MessageText:
//
//  Could not lock mutex.
//
#define TLR_E_EPL_NMT_COULD_NOT_LOCK_MUTEX ((TLR_RESULT)0xC0170019L)

//
// MessageId: TLR_E_EPL_NMT_INVALID_STATIC_BIT_FIELD_NUMBER
//
// MessageText:
//
//  Invalid static bit field bit number.
//
#define TLR_E_EPL_NMT_INVALID_STATIC_BIT_FIELD_NUMBER ((TLR_RESULT)0xC017001AL)

//
// MessageId: TLR_E_EPL_NMT_NO_MORE_APP_HANDLES
//
// MessageText:
//
//  No more App handles.
//
#define TLR_E_EPL_NMT_NO_MORE_APP_HANDLES ((TLR_RESULT)0xC017001BL)

//
// MessageId: TLR_E_EPL_NMT_APP_NOT_REGISTERED
//
// MessageText:
//
//  Application queue is not registered.
//
#define TLR_E_EPL_NMT_APP_NOT_REGISTERED ((TLR_RESULT)0xC017001CL)

//
// MessageId: TLR_E_EPL_NMT_APP_ALREADY_REGISTERED
//
// MessageText:
//
//  Application queue is already registered.
//
#define TLR_E_EPL_NMT_APP_ALREADY_REGISTERED ((TLR_RESULT)0xC017001DL)

//
// MessageId: TLR_E_EPL_NMT_FAILED_TO_INITIALIZE_EPLCN_INTERFACE
//
// MessageText:
//
//  EplCn-Interface could not be initialized.
//
#define TLR_E_EPL_NMT_FAILED_TO_INITIALIZE_EPLCN_INTERFACE ((TLR_RESULT)0xC017001EL)

//
// MessageId: TLR_E_EPL_NMT_INVALID_PARAMETERS
//
// MessageText:
//
//  Invalid Parameters.
//
#define TLR_E_EPL_NMT_INVALID_PARAMETERS ((TLR_RESULT)0xC017001FL)

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL MN Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_MN_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_MN_COMMAND_INVALID     ((TLR_RESULT)0xC03D0001L)

//
// MessageId: TLR_E_EPL_MN_CN_EXISTS
//
// MessageText:
//
//  CN exists already.
//
#define TLR_E_EPL_MN_CN_EXISTS           ((TLR_RESULT)0xC03D0002L)

//
// MessageId: TLR_E_EPL_MN_CN_DOES_NOT_EXIST
//
// MessageText:
//
//  CN does not exist.
//
#define TLR_E_EPL_MN_CN_DOES_NOT_EXIST   ((TLR_RESULT)0xC03D0003L)

//
// MessageId: TLR_E_EPL_MN_CN_ALREADY_CONNECTED
//
// MessageText:
//
//  CN already connected.
//
#define TLR_E_EPL_MN_CN_ALREADY_CONNECTED ((TLR_RESULT)0xC03D0004L)

//
// MessageId: TLR_E_EPL_MN_CN_NO_OUTPUT_DATA
//
// MessageText:
//
//  CN has no valid output data.
//
#define TLR_E_EPL_MN_CN_NO_OUTPUT_DATA   ((TLR_RESULT)0xC03D0005L)

/////////////////////////////////////////////////////////////////////////////////////
// POWERLINK EPL PLD Packet Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_E_EPL_PLD_COMMAND_INVALID
//
// MessageText:
//
//  Invalid command received.
//
#define TLR_E_EPL_PLD_COMMAND_INVALID    ((TLR_RESULT)0xC0190001L)




#endif  //__EPL_ERROR_H

